/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jeirei;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.FakeSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.util.CraftingRecipeUtil;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public final class EncodingHelper {
    static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::isCraftable).thenComparing(EncodingHelper::isUndamaged).thenComparing(GridInventoryEntry::getStoredAmount);

    private EncodingHelper() {
    }

    private static Boolean isUndamaged(GridInventoryEntry entry) {
        AEItemKey itemKey;
        AEKey aEKey = entry.getWhat();
        return !(aEKey instanceof AEItemKey) || !(itemKey = (AEItemKey)aEKey).isDamaged();
    }

    public static void encodeProcessingRecipe(PatternEncodingTermMenu menu, List<List<GenericStack>> genericIngredients, List<GenericStack> genericResults) {
        menu.setMode(EncodingMode.PROCESSING);
        Map<AEKey, Integer> ingredientPriorities = EncodingHelper.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        EncodingHelper.encodeBestMatchingStacksIntoSlots(genericIngredients, ingredientPriorities, menu.getProcessingInputSlots());
        EncodingHelper.encodeBestMatchingStacksIntoSlots(genericResults.stream().map(List::of).toList(), ingredientPriorities, menu.getProcessingOutputSlots());
    }

    private static void encodeBestMatchingStacksIntoSlots(List<List<GenericStack>> possibleInputsBySlot, Map<AEKey, Integer> ingredientPriorities, FakeSlot[] slots) {
        ArrayList<GenericStack> encodedInputs = new ArrayList<GenericStack>();
        for (List<GenericStack> genericIngredient : possibleInputsBySlot) {
            if (genericIngredient.isEmpty()) continue;
            EncodingHelper.addOrMerge(encodedInputs, EncodingHelper.findBestIngredient(ingredientPriorities, genericIngredient));
        }
        for (int i = 0; i < slots.length; ++i) {
            FakeSlot slot = slots[i];
            class_1799 stack = i < encodedInputs.size() ? GenericStack.wrapInItemStack(encodedInputs.get(i)) : class_1799.field_8037;
            slot.setFilterTo(stack);
        }
    }

    public static boolean isSupportedCraftingRecipe(@Nullable class_1860<?> recipe) {
        if (recipe == null) {
            return false;
        }
        class_3956 recipeType = recipe.method_17716();
        return recipeType == class_3956.field_17545 || recipeType == class_3956.field_17641 || recipeType == class_3956.field_25388;
    }

    public static void encodeCraftingRecipe(PatternEncodingTermMenu menu, @Nullable class_1860<?> recipe, List<List<GenericStack>> genericIngredients, Predicate<class_1799> visiblePredicate) {
        if (recipe != null && recipe.method_17716().equals(class_3956.field_17641)) {
            menu.setMode(EncodingMode.STONECUTTING);
            menu.setStonecuttingRecipeId(recipe.method_8114());
        } else if (recipe != null && recipe.method_17716().equals(class_3956.field_25388)) {
            menu.setMode(EncodingMode.SMITHING_TABLE);
        } else {
            menu.setMode(EncodingMode.CRAFTING);
        }
        Map<AEKey, Integer> prioritizedNetworkInv = EncodingHelper.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        class_2371 encodedInputs = class_2371.method_10213((int)menu.getCraftingGridSlots().length, (Object)class_1799.field_8037);
        if (recipe != null) {
            class_2371<class_1856> ingredients3x3 = CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
            for (int slot = 0; slot < ingredients3x3.size(); ++slot) {
                class_1856 ingredient = (class_1856)ingredients3x3.get(slot);
                if (ingredient.method_8103()) continue;
                Optional<class_1799> bestNetworkIngredient = prioritizedNetworkInv.entrySet().stream().filter(ni -> {
                    AEItemKey itemKey;
                    Object patt5605$temp = ni.getKey();
                    return patt5605$temp instanceof AEItemKey && ingredient.method_8093((itemKey = (AEItemKey)patt5605$temp).toStack());
                }).max(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> {
                    class_1799 class_17992;
                    Object patt5801$temp = entry.getKey();
                    if (patt5801$temp instanceof AEItemKey) {
                        AEItemKey itemKey = (AEItemKey)patt5801$temp;
                        class_17992 = itemKey.toStack();
                    } else {
                        class_17992 = null;
                    }
                    return class_17992;
                });
                class_1799 bestIngredient = bestNetworkIngredient.orElseGet(() -> {
                    for (class_1799 stack : ingredient.method_8105()) {
                        if (!visiblePredicate.test(stack)) continue;
                        return stack;
                    }
                    return ingredient.method_8105()[0];
                });
                encodedInputs.set(slot, (Object)bestIngredient);
            }
        } else {
            for (int slot = 0; slot < genericIngredients.size(); ++slot) {
                List<GenericStack> genericIngredient = genericIngredients.get(slot);
                if (genericIngredient.isEmpty()) continue;
                AEKey bestIngredient = EncodingHelper.findBestIngredient(prioritizedNetworkInv, genericIngredient).what();
                if (bestIngredient instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)bestIngredient;
                    encodedInputs.set(slot, (Object)itemKey.toStack());
                    continue;
                }
                encodedInputs.set(slot, (Object)GenericStack.wrapInItemStack(bestIngredient, 1L));
            }
        }
        for (int i = 0; i < encodedInputs.size(); ++i) {
            class_1799 encodedInput = (class_1799)encodedInputs.get(i);
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, menu.getCraftingGridSlots()[i].field_7874, encodedInput));
        }
        for (FakeSlot outputSlot : menu.getProcessingOutputSlots()) {
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, outputSlot.field_7874, class_1799.field_8037));
        }
    }

    private static GenericStack findBestIngredient(Map<AEKey, Integer> ingredientPriorities, List<GenericStack> possibleIngredients) {
        return possibleIngredients.stream().map(gi -> Pair.of((Object)gi, (Object)ingredientPriorities.getOrDefault(gi.what(), Integer.MIN_VALUE))).max(Comparator.comparingInt(Pair::getRight)).map(Pair::getLeft).orElseThrow();
    }

    private static void addOrMerge(List<GenericStack> stacks, GenericStack newStack) {
        for (int i = 0; i < stacks.size(); ++i) {
            GenericStack existingStack = stacks.get(i);
            if (!Objects.equals(existingStack.what(), newStack.what())) continue;
            long newAmount = LongMath.saturatedAdd((long)existingStack.amount(), (long)newStack.amount());
            stacks.set(i, new GenericStack(newStack.what(), newAmount));
            long overflow = newStack.amount() - (newAmount - existingStack.amount());
            if (overflow > 0L) {
                stacks.add(new GenericStack(newStack.what(), overflow));
            }
            return;
        }
        stacks.add(newStack);
    }

    public static Map<AEKey, Integer> getIngredientPriorities(MEStorageMenu menu, Comparator<GridInventoryEntry> comparator) {
        List<AEKey> orderedEntries = menu.getClientRepo().getAllEntries().stream().sorted(comparator).map(GridInventoryEntry::getWhat).toList();
        HashMap<AEKey, Integer> result = new HashMap<AEKey, Integer>(orderedEntries.size());
        for (int i = 0; i < orderedEntries.size(); ++i) {
            result.put(orderedEntries.get(i), i);
        }
        for (class_1799 item : menu.getPlayerInventory().field_7547) {
            AEItemKey key = AEItemKey.of(item);
            if (key == null) continue;
            result.putIfAbsent(key, -1);
        }
        return result;
    }
}

